-- --------------------------------------------------------------------------
-- Copyright  2008 PlayFirst, Inc. All Rights Reserved.
--
-- This material is the confidential trade secret and proprietary
-- information of PlayFirst, Inc. It may not be reproduced, used, disclosed,
-- sold or transferred without the prior written consent of PlayFirst, Inc. 
-- All rights reserved.
-- --------------------------------------------------------------------------
dofile( "scripts/tittle_style.lua" );

kTittleY = 150;
kTextButton = 30;
kTextStartX = 240;
kTextStartY = 40;
kSoundBarY = 210;
kLineSpaceY = 60;
kVolumeWidth = 280;
kSoundButtonAlign =-8;
kSoundTittleAlign =-30;
kCheckBoxY = kSoundBarY+2*kLineSpaceY-20;
kCheckBoxSpaceX = 130;
kButtonY = kMax-210;

SliderFont = {
  standardFont,
  16,
  AquaColor
};

MakeDialog
{
	-- Name the modal dialog
	name="optionsmenu",
	Bitmap
	{
		image="images/ui/common/popup03",
		x = kCenter,
		y = kCenter,
		
		Text
		{
			font = PopupFont,
			x=kCenter,
			y=kTittleY,
			w=kMax,h=50,
			flags = kHAlignCenter + kVAlignTop,
			label = "options"
		};
		OptionsWindow
		{
			x=0,y=0,w=kMax,h=kMax,
--SFX level		
			Text
			{
				font = SliderFont,
				name = "sfx",
				x=kTextStartX,
				y=kSoundBarY+kSoundTittleAlign,
				w=50,h=50,
				flags = kHAlignCenter + kVAlignTop,
				label = "sfxlevel"
			};
			SetStyle(SliderStyleFitness),
			Bitmap
			{
				image = "images/ui/buttons/soundbar",
				x=kCenter,
				y=kSoundBarY,
				flags = kHAlignCenter + kVAlignTop,
			};
			Slider
			{
				name="sfxlevelslider",
				x = kCenter,
				y = kSoundBarY+kSoundButtonAlign,
				w = kVolumeWidth,
				flags = kHAlignCenter + kVAlignTop,
			};
--Music Level		
			Text
			{
				font = SliderFont,
				name = "music",
				x=kTextStartX,
				y=kSoundBarY+kLineSpaceY+kSoundTittleAlign,
				w=50,h=50,
				flags = kHAlignCenter + kVAlignTop,
				label = "musiclevel"
			};
			Bitmap
			{
				image = "images/ui/buttons/soundbar",
				x=kCenter,
				y=kSoundBarY+kLineSpaceY,
				flags = kHAlignCenter + kVAlignTop,
			};
			Slider
			{
				name="musiclevelslider",
				x = kCenter,
				y = kSoundBarY+kLineSpaceY+kSoundButtonAlign,
				w = kVolumeWidth,
				flags = kHAlignCenter + kVAlignTop,
			};

			SetStyle(CheckboxButtonStyleFitness),			
			Button{
				name="fullscreen",
				x=kTextStartX,
				y=kCheckBoxY,
				w=150,
				flags = kHAlignCenter + kVAlignTop,
				sound = "audio/sfx/checkbox.ogg",
				
				Text
				{
					font = SliderFont,
					name = "fullscreenlabel",
					x=54,
					y=25,
					w=kMax,
					h=kMax,
					flags = kHAlignLeft + kVAlignTop,
					label="fullscreen",
				};
				command=
				function()
					if (ToggleFullScreen() == false) then
						DisplayDialog { 
							"scripts/ok.lua", 
							body ="screenswitchfailed",
							title = "playground" 
						};
					end
				end
				
			};
			
			Button{
				name="mutebox",
				x=kTextStartX+kCheckBoxSpaceX,
				y=kCheckBoxY,
				w=175,
				flags = kHAlignCenter + kVAlignTop,
				
				sound = "audio/sfx/checkbox.ogg",
				Text
				{
					font = SliderFont,
					name = "mutesoundlabel",
					x=54,
					y=25,
					w=kMax,
					h=kMax,
					flags = kHAlignLeft + kVAlignTop,
					label="mutesound",
				};
				command =
					function()
						ToggleSoundMute();
					end
			};
			SetStyle(FitnessButtonStyleTittleSmallBlue2),
--Ok

			SBButton
			{
				x		= kCenter+150,
				y		= kButtonY,
				name	= "ok",
				label	="common.ok.label",
				icon	= "assets/images/ui/buttons/icon/iconok",
				command =
					function()
						SaveVolumes();
						PopModal("optionsmenu");
					end
			},
--Credit
			SBButton
			{
				x = kCenter+80,
				y = kButtonY,
				name="credits",
				label="credits",
				icon	= "assets/images/ui/buttons/icon/iconcredit",
				command =
					function()
						DoModal("scripts/credits.lua");
					end
			},
		},
	},
}